<?php
/*======================================================================*\
|| #################################################################### ||
|| # Egg Avatar for vBulletin 3.8.x   								  # ||
|| # ---------------------------------------------------------------- # ||
|| # Originally created by [tk] Software (Hamster Powered)            # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('cphome');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');

// ######################## CHECK ADMIN PERMISSIONS #########################
// don't allow demo version or admin with no permission to change egg images
if (is_demo_mode() OR !can_administer('canadminsettings'))
{
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action('Egg Avatar Admin');

print_cp_header($vbphrase['eggavatar_system']);

function scandir4($dir) 
{
    $dh  = opendir($dir);
    while (false !== ($filename = readdir($dh))) 
    {
        $files[] = $filename;
    }

    sort($files);
    
    return $files;
}

function resize_image($imagepath, $iwidth, $iheight)
{
    $max = max($iwidth, $iheight);
    $percent = 50 / $max;
    $width = $iwidth * $percent;
    $height = $iheight * $percent;
    $org = imagecreatefromgif($imagepath);
    $new = imagecreatetruecolor($width, $height);
    imagealphablending($new, false); 
    $transparent = imagecolorallocatealpha($new, 0, 0, 0, 127); 
    imagecolortransparent($new, $transparent); 
    imagefill($new, 0, 0, $transparent);
    imagecopyresized($new, $org, 0, 0, 0, 0, $width, $height, $iwidth, $iheight);
    imagealphablending($new, true); 
    imagesavealpha($new, true);
           
    ob_start();
    imagegif($new);
    $content = ob_get_contents();
    ob_end_clean();
    
    $f = fopen($imagepath, "w");
    fwrite($f, $content);
    fclose($f);
    imagedestroy($new);
    imagedestroy($org);

    // we only want the filename
    $fparts = explode("/", $imagepath);
    $filename = $fparts[count($fparts) - 1];

    return $filename;
}

// #############################################################################

if ($_GET['do'] == 'update')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'imageid'		=> TYPE_UINT,
		'action'	    => TYPE_STR,
		'image'         => TYPE_STR,
	));
	
    if ($vbulletin->GPC['action'] == 'del')
    {
        $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "eggimage WHERE imageid = " . $vbulletin->GPC['imageid']);
    }
    elseif ($vbulletin->GPC['action'] == 'disable')
    {
        $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "eggimage SET active = 0 WHERE imageid = " . $vbulletin->GPC['imageid']);
    }
    elseif ($vbulletin->GPC['action'] == 'enable')
    {
        $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "eggimage SET active = 1 WHERE imageid = " . $vbulletin->GPC['imageid']);
    }
    elseif ($vbulletin->GPC['action'] == 'edit')
    {
     	print_cp_redirect("eggadmin.php?do=modify&imageid=" . $vbulletin->GPC['imageid'] . "&action=edit");
    }
    elseif ($vbulletin->GPC['action'] == 'add')
    {
        $imagepath = DIR . '/' . $vbulletin->options['eggavatar_eggpath'] . $vbulletin->GPC['image'];   
        list($iwidth, $iheight, $type) = getimagesize($imagepath);

        // resize and overwrite if needed: max size 50x50
        if ($iwidth > 50 OR $iheight > 50)
        {
            $filename = resize_image($imagepath, $iwidth, $iheight);
        }
        else
        {
            $filename = $vbulletin->GPC['image'];
        }

        $vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "eggimage (name, effect, image, active) VALUES('Throw', 0, '" . $filename . "', 0)");
    }
    elseif ($vbulletin->GPC['action'] == 'remove')
    {
     	unlink(DIR . '/' . $vbulletin->options['eggavatar_eggpath'] . $vbulletin->GPC['image']);
    }

   	define('CP_REDIRECT', "eggadmin.php?do=modify");
   	print_stop_message('eggavatar_updated_successfully');
}

// #############################################################################

if ($_POST['do'] == 'add')
{
	$vbulletin->input->clean_array_gpc('f', array(
		'upload'  => TYPE_FILE,
	));
    
    $vbulletin->input->clean_array_gpc('p', array(
		'mode'        => TYPE_STR,
		'imageid'     => TYPE_UINT,
		'name'        => TYPE_STR,
		'effect'	  => TYPE_UINT,
		'image'       => TYPE_STR,
	));

    define('CP_REDIRECT', "eggadmin.php?do=modify&imageid=" . $vbulletin->GPC['imageid']);
    
  	// duplicate names are not allowed
  	if (!empty($vbulletin->GPC['upload']['name']))
    {
      	unset($exists);
        $exists = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "eggimage WHERE image = '" . $vbulletin->GPC['upload']['name'] . "'");
        if ($exists)
        {
            if (empty($vbulletin->GPC['imageid']))
            {
                print_stop_message('eggavatar_duplicate_image');
   	        }
   	        if (!empty($vbulletin->GPC['imageid']) AND $vbulletin->GPC['imageid'] != $exists['imageid'])
   	        {
                print_stop_message('eggavatar_duplicate_image'); 
   	        }
        }
    }

    if (empty($vbulletin->GPC['imageid']))
    {
    	require_once(DIR . '/includes/class_upload.php');
    	require_once(DIR . '/includes/class_image.php');
    
    	$upload = new vB_Upload_Image($vbulletin);
    	$upload->image =& vB_Image::fetch_library($vbulletin);
    	$upload->path = $vbulletin->options['eggavatar_eggpath'];
    
    	if (!($imagepath = $upload->process_upload($vbulletin->GPC['upload'])))
    	{
      		print_stop_message('there_were_errors_encountered_with_your_upload_x', $upload->fetch_error());
        }    
        
        list($iwidth, $iheight, $type) = getimagesize($imagepath);
        // make sure it's a gif file
        if ($type != IMAGETYPE_GIF)
        {
            unlink($imagepath);
            print_stop_message('eggavatar_imagenotgif');
        }

        // resize and overwrite if needed: max size 50x50
        if ($iwidth > 50 OR $iheight > 50)
        {
            $filename = resize_image($imagepath, $iwidth, $iheight);
        }
        else
        {
            $filename = $imagepath;
        }
                     
        // we only want the filename
        $fparts = explode("/", $imagepath);
        $filename = $fparts[count($fparts) - 1];
        
        // write the image
	    $db->query_write("
	   	   INSERT INTO " . TABLE_PREFIX . "eggimage
		   (name, effect, image, active)
		   VALUES ('" . 
            $vbulletin->GPC['name'] . "', " . 
            $vbulletin->GPC['effect'] . ", '" .
           $filename . "', 1)
	   ");
    }
    else
    {
        // has the file changed?
        if (!empty($vbulletin->GPC['upload']['name']))
        {
        	require_once(DIR . '/includes/class_upload.php');
        	require_once(DIR . '/includes/class_image.php');
        
        	$upload = new vB_Upload_Image($vbulletin);
        	$upload->image =& vB_Image::fetch_library($vbulletin);
        	$upload->path = $vbulletin->options['eggavatar_eggpath'];
        
        	if (!($imagepath = $upload->process_upload($vbulletin->GPC['upload'])))
        	{
        		print_stop_message('there_were_errors_encountered_with_your_upload_x', $upload->fetch_error());
            }
            
            list($iwidth, $iheight, $type) = getimagesize($imagepath);
            // make sure it's a gif file
            if ($type != IMAGETYPE_GIF)
            {
                unlink($imagepath);
                print_stop_message('eggavatar_imagenotgif');
            }
            // resize and overwrite if needed: max size 50x50
            if ($iwidth > 50 OR $iheight > 50)
            {
                $max = max($iwidth, $iheight);
                $percent = 50 / $max;
                $width = $iwidth * $percent;
                $height = $iheight * $percent;
                $org = imagecreatefromgif($imagepath);
                $new = imagecreatetruecolor($width, $height);
                imagealphablending($new, false); 
                $transparent = imagecolorallocatealpha($new, 0, 0, 0, 127); 
                imagecolortransparent($new, $transparent); 
                imagefill($new, 0, 0, $transparent);
                imagecopyresized($new, $org, 0, 0, 0, 0, $width, $height, $iwidth, $iheight);
                imagealphablending($new, true); 
                imagesavealpha($new, true);
                       
                ob_start();
                imagegif($new);
                $content = ob_get_contents();
                ob_end_clean();
                
                $f = fopen($imagepath, "w");
                fwrite($f, $content);
                fclose($f);
                imagedestroy($new);
                imagedestroy($old);
            }            
            
            // we only want the filename
            $fparts = explode("/", $imagepath);
            $filename = $fparts[count($fparts) - 1];
        }
        else
        {
            $filename = $vbulletin->GPC['image'];
        }
        
        $db->query_write("UPDATE " . TABLE_PREFIX . "eggimage SET 
            name='" . $vbulletin->GPC['name'] . "',
            effect=" . $vbulletin->GPC['effect'] . ",
            image='" . $filename . "'
            WHERE imageid=" . $vbulletin->GPC['imageid']
        );
    }	
	print_stop_message('eggavatar_saved_successfully');
}

// #############################################################################

if ($_REQUEST['do'] == 'modify')
{
	?>
	<script type="text/javascript">
	function js_page_jump(i, imageid, image)
	{
		var sel = fetch_object("action" + i);
		var act = sel.options[sel.selectedIndex].value;
		if (act != '')
		{
			switch (act)
			{
				case 'disable': page = "eggadmin.php?do=update&action=disable&imageid="; break;
				case 'enable': page = "eggadmin.php?do=update&action=enable&imageid="; break;
				case 'edit': page = "eggadmin.php?do=update&action=edit&imageid="; break;
				case 'del': page = "eggadmin.php?do=update&action=del&imageid="; break;
				case 'add': page = "eggadmin.php?do=update&action=add&imageid="; break;
				case 'remove': page = "eggadmin.php?do=update&action=remove&imageid="; break;
				default: return;
			}
			document.cpform2.reset();
			jumptopage = page + imageid + "&image=" + image + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
			window.location = jumptopage;
		}
		else
		{
			alert('<?php echo addslashes_js($vbphrase['invalid_action_specified']); ?>');
		}
	}
	</script>
	<?php
    
    $vbulletin->input->clean_array_gpc('r', array(
		'imageid'     => TYPE_UINT,
		'action'      => TYPE_STR
	));
    
    print_form_header('eggadmin', 'add', true, true, 'cpform1');
    if ($vbulletin->GPC['action'] == 'edit')
    {
        $image = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "eggimage WHERE imageid = " . $vbulletin->GPC['imageid']);
    }
    
    if ($vbulletin->GPC['action'] == 'edit')
    {
	   print_table_header($vbphrase['eggavatar_edit_header'] . '&nbsp;&nbsp;<span style="font-weight: normal">(<a href="eggadmin?do=modify">clear</a>)</span>', 2);
    }
    else
    {
	   print_table_header($vbphrase['eggavatar_add_header'], 2);
    }	
    
	construct_hidden_code('imageid', $image['imageid']);
	construct_hidden_code('image', $image['image']);
	print_input_row($vbphrase['eggavatar_name'], 'name', $image['name'], true, 50, 100);
	$effarr = explode(",", $vbphrase['eggavatar_effect_array']);
	print_select_row($vbphrase['eggavatar_effect'], 'effect', $effarr, $image['effect']);
 	print_label_row($vbphrase['eggavatar_current_image'], $image['image'], '', 'top', NULL, true);
  	print_upload_row($vbphrase['eggavatar_image_upload'], 'upload', 120000);
    print_hidden_fields();
    if ($vbulletin->GPC['action'] == 'edit')
    {
    	print_submit_row($vbphrase['eggavatar_edit'], false);
	}
	else
	{
    	print_submit_row($vbphrase['eggavatar_create'], false);
	}
    
	print_form_header('eggadmin', 'update', false, true, "cpform2");
	print_table_header($vbphrase['eggavatar_settings_header'], 4);
	print_cells_row(
        array(
            $vbphrase['eggavatar_image'], 
            $vbphrase['eggavatar_name'],
            $vbphrase['eggavatar_effect'],
            $vbphrase['eggavatar_action'],
        ), 1);
	
	// get all the images in the database
	$images = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "eggimage");
    // convert to an array
    while ($image = $vbulletin->db->fetch_array($images))
    {
        $imagearr[] = $image;
    }
    
    if (!file_exists(DIR . '/' . $vbulletin->options['eggavatar_eggpath']))
    {
       print_table_header($vbphrase['eggavatar_invalid_path'], 4);
    }
    else
    {
        // now get all the images in the filepath but not in the database
        $files = scandir4(DIR . '/' . $vbulletin->options['eggavatar_eggpath']);
        array_shift($files);
        array_shift($files);
        foreach($files as $file)
        {
            $found = false;
            foreach($imagearr as $imagerow)
            {
                if ($file == $imagerow['image'] AND !is_dir(DIR . '/' . $vbulletin->options['eggavatar_eggpath'] . $file))
                {
                    list($iwidth, $iheight, $type) = getimagesize(DIR . '/' . $vbulletin->options['eggavatar_eggpath'] . $file);
                    if ($type == IMAGETYPE_GIF)
                    {
                        $found = true;
                    }
                }
            }
            if (!$found)
            {
                $imagearr[] = array("imageid" => 0, "name" => '', "effect" => 0, "image" => $file, "active" => 0);
            }
        }
    
        $actions_db = array(
            'edit' => $vbphrase['eggavatar_action_edit'],
            'del' => $vbphrase['eggavatar_action_del'],
            'enable' => $vbphrase['eggavatar_action_enable'],
            'disable' => $vbphrase['eggavatar_action_disable'],
        );
        
        $actions_fs = array(
            'add' => $vbphrase['eggavatar_action_add'],
            'remove' => $vbphrase['eggavatar_action_remove'],
        );
    
        $i = 0;
    	foreach ($imagearr as $image)
    	{	   
            $name = $image['name'];
    	    if (!$image['active']) 
            { 
                $name = "<del>" . $name . "<del>";
            }
            if (empty($image['imageid']))
            {
                $actions = $actions_fs;
            }
            else
            {
                $actions = $actions_db;
            }
            $i++;
            $imgpath = DIR . '/' . $vbulletin->options['eggavatar_eggpath'] . $image['image'];
            if (file_exists($imgpath))
            {
                list($imgw, $imgh, $imgt) = getimagesize($imgpath);
                $max = max($imgw, $imgh);
                if ($max > 50)
                {
                    $adjust = 50 / $max;
                    $imgw *= $adjust;
                    $imgh *= $adjust;
                }
                $imgrow = '<img src="../' . $vbulletin->options['eggavatar_eggpath'] . $image['image'] . '" width="' . $imgw . '" height="' . $imgh . '" style="inline"/>';
            }
            else
            {
                $imgrow = $vbphrase['eggavatar_missing_image'];
            }
           	$effarr = explode(",", $vbphrase['eggavatar_effect_array']);
    		print_cells_row(array(
                $imgrow,
    			$name, 
    			$effarr[$image['effect']],
    			"<select id='action" . $i . "' class='bginput' onchange=\"js_page_jump(" . $i . "," . $image['imageid']  . ",'" . $image['image'] . "');\">" . construct_select_options($actions, 'edit') . "</select>&nbsp;<input type='button' value='" . $vbphrase['eggavatar_gobutton'] . "' onclick=\"js_page_jump(" . $i . "," . $image['imageid']  . ",'" . $image['image'] . "');\"/>", 
            ));							
    	}
    }		
	print_table_footer(4);
}

// #############################################################################
// #############################################################################
// #############################################################################

print_cp_footer();

?>